<?php
/**
 * AccountUISettings
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * DocuSign REST API
 *
 * The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.
 *
 * OpenAPI spec version: v2.1
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.21
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Model;

use \ArrayAccess;
use DocuSign\eSign\ObjectSerializer;

/**
 * AccountUISettings Class Doc Comment
 *
 * @category    Class
 * @description An object that defines the options that are available to non-administrators in the UI.
 * @package     DocuSign\eSign
 * @author      Swagger Codegen team <apihelp@docusign.com>
 * @license     The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class AccountUISettings implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'accountUISettings';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'admin_message' => '\DocuSign\eSign\Model\AdminMessage',
        'allow_users_to_edit_shared_access' => '?string',
        'allow_users_to_edit_shared_access_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'ask_an_admin' => '\DocuSign\eSign\Model\AskAnAdmin',
        'clickwrap_schema_version' => '?string',
        'clickwrap_schema_version_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_admin_message' => '?string',
        'enable_admin_message_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_easy_sign_can_use_multi_template_apply' => '?string',
        'enable_easy_sign_can_use_multi_template_apply_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_easy_sign_template_upload' => '?string',
        'enable_easy_sign_template_upload_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_envelope_copy_with_data' => '?string',
        'enable_envelope_copy_with_data_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_legacy_sendflow_link' => '?string',
        'enable_legacy_sendflow_link_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'has_external_linked_accounts' => '?string',
        'has_external_linked_accounts_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'hide_send_an_envelope' => '?string',
        'hide_send_an_envelope_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'hide_use_a_template' => '?string',
        'hide_use_a_template_in_prepare' => '?string',
        'hide_use_a_template_in_prepare_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'hide_use_a_template_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'order_based_recipient_id_generation' => '?string',
        'order_based_recipient_id_generation_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'remove_envelope_forwarding' => '?string',
        'remove_envelope_forwarding_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'should_redact_access_code' => '?string',
        'should_redact_access_code_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'upload_new_image_to_sign_or_initial' => '?string',
        'upload_new_image_to_sign_or_initial_metadata' => '\DocuSign\eSign\Model\SettingsMetadata'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'admin_message' => null,
        'allow_users_to_edit_shared_access' => null,
        'allow_users_to_edit_shared_access_metadata' => null,
        'ask_an_admin' => null,
        'clickwrap_schema_version' => null,
        'clickwrap_schema_version_metadata' => null,
        'enable_admin_message' => null,
        'enable_admin_message_metadata' => null,
        'enable_easy_sign_can_use_multi_template_apply' => null,
        'enable_easy_sign_can_use_multi_template_apply_metadata' => null,
        'enable_easy_sign_template_upload' => null,
        'enable_easy_sign_template_upload_metadata' => null,
        'enable_envelope_copy_with_data' => null,
        'enable_envelope_copy_with_data_metadata' => null,
        'enable_legacy_sendflow_link' => null,
        'enable_legacy_sendflow_link_metadata' => null,
        'has_external_linked_accounts' => null,
        'has_external_linked_accounts_metadata' => null,
        'hide_send_an_envelope' => null,
        'hide_send_an_envelope_metadata' => null,
        'hide_use_a_template' => null,
        'hide_use_a_template_in_prepare' => null,
        'hide_use_a_template_in_prepare_metadata' => null,
        'hide_use_a_template_metadata' => null,
        'order_based_recipient_id_generation' => null,
        'order_based_recipient_id_generation_metadata' => null,
        'remove_envelope_forwarding' => null,
        'remove_envelope_forwarding_metadata' => null,
        'should_redact_access_code' => null,
        'should_redact_access_code_metadata' => null,
        'upload_new_image_to_sign_or_initial' => null,
        'upload_new_image_to_sign_or_initial_metadata' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'admin_message' => 'adminMessage',
        'allow_users_to_edit_shared_access' => 'allowUsersToEditSharedAccess',
        'allow_users_to_edit_shared_access_metadata' => 'allowUsersToEditSharedAccessMetadata',
        'ask_an_admin' => 'askAnAdmin',
        'clickwrap_schema_version' => 'clickwrapSchemaVersion',
        'clickwrap_schema_version_metadata' => 'clickwrapSchemaVersionMetadata',
        'enable_admin_message' => 'enableAdminMessage',
        'enable_admin_message_metadata' => 'enableAdminMessageMetadata',
        'enable_easy_sign_can_use_multi_template_apply' => 'enableEasySignCanUseMultiTemplateApply',
        'enable_easy_sign_can_use_multi_template_apply_metadata' => 'enableEasySignCanUseMultiTemplateApplyMetadata',
        'enable_easy_sign_template_upload' => 'enableEasySignTemplateUpload',
        'enable_easy_sign_template_upload_metadata' => 'enableEasySignTemplateUploadMetadata',
        'enable_envelope_copy_with_data' => 'enableEnvelopeCopyWithData',
        'enable_envelope_copy_with_data_metadata' => 'enableEnvelopeCopyWithDataMetadata',
        'enable_legacy_sendflow_link' => 'enableLegacySendflowLink',
        'enable_legacy_sendflow_link_metadata' => 'enableLegacySendflowLinkMetadata',
        'has_external_linked_accounts' => 'hasExternalLinkedAccounts',
        'has_external_linked_accounts_metadata' => 'hasExternalLinkedAccountsMetadata',
        'hide_send_an_envelope' => 'hideSendAnEnvelope',
        'hide_send_an_envelope_metadata' => 'hideSendAnEnvelopeMetadata',
        'hide_use_a_template' => 'hideUseATemplate',
        'hide_use_a_template_in_prepare' => 'hideUseATemplateInPrepare',
        'hide_use_a_template_in_prepare_metadata' => 'hideUseATemplateInPrepareMetadata',
        'hide_use_a_template_metadata' => 'hideUseATemplateMetadata',
        'order_based_recipient_id_generation' => 'orderBasedRecipientIdGeneration',
        'order_based_recipient_id_generation_metadata' => 'orderBasedRecipientIdGenerationMetadata',
        'remove_envelope_forwarding' => 'removeEnvelopeForwarding',
        'remove_envelope_forwarding_metadata' => 'removeEnvelopeForwardingMetadata',
        'should_redact_access_code' => 'shouldRedactAccessCode',
        'should_redact_access_code_metadata' => 'shouldRedactAccessCodeMetadata',
        'upload_new_image_to_sign_or_initial' => 'uploadNewImageToSignOrInitial',
        'upload_new_image_to_sign_or_initial_metadata' => 'uploadNewImageToSignOrInitialMetadata'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'admin_message' => 'setAdminMessage',
        'allow_users_to_edit_shared_access' => 'setAllowUsersToEditSharedAccess',
        'allow_users_to_edit_shared_access_metadata' => 'setAllowUsersToEditSharedAccessMetadata',
        'ask_an_admin' => 'setAskAnAdmin',
        'clickwrap_schema_version' => 'setClickwrapSchemaVersion',
        'clickwrap_schema_version_metadata' => 'setClickwrapSchemaVersionMetadata',
        'enable_admin_message' => 'setEnableAdminMessage',
        'enable_admin_message_metadata' => 'setEnableAdminMessageMetadata',
        'enable_easy_sign_can_use_multi_template_apply' => 'setEnableEasySignCanUseMultiTemplateApply',
        'enable_easy_sign_can_use_multi_template_apply_metadata' => 'setEnableEasySignCanUseMultiTemplateApplyMetadata',
        'enable_easy_sign_template_upload' => 'setEnableEasySignTemplateUpload',
        'enable_easy_sign_template_upload_metadata' => 'setEnableEasySignTemplateUploadMetadata',
        'enable_envelope_copy_with_data' => 'setEnableEnvelopeCopyWithData',
        'enable_envelope_copy_with_data_metadata' => 'setEnableEnvelopeCopyWithDataMetadata',
        'enable_legacy_sendflow_link' => 'setEnableLegacySendflowLink',
        'enable_legacy_sendflow_link_metadata' => 'setEnableLegacySendflowLinkMetadata',
        'has_external_linked_accounts' => 'setHasExternalLinkedAccounts',
        'has_external_linked_accounts_metadata' => 'setHasExternalLinkedAccountsMetadata',
        'hide_send_an_envelope' => 'setHideSendAnEnvelope',
        'hide_send_an_envelope_metadata' => 'setHideSendAnEnvelopeMetadata',
        'hide_use_a_template' => 'setHideUseATemplate',
        'hide_use_a_template_in_prepare' => 'setHideUseATemplateInPrepare',
        'hide_use_a_template_in_prepare_metadata' => 'setHideUseATemplateInPrepareMetadata',
        'hide_use_a_template_metadata' => 'setHideUseATemplateMetadata',
        'order_based_recipient_id_generation' => 'setOrderBasedRecipientIdGeneration',
        'order_based_recipient_id_generation_metadata' => 'setOrderBasedRecipientIdGenerationMetadata',
        'remove_envelope_forwarding' => 'setRemoveEnvelopeForwarding',
        'remove_envelope_forwarding_metadata' => 'setRemoveEnvelopeForwardingMetadata',
        'should_redact_access_code' => 'setShouldRedactAccessCode',
        'should_redact_access_code_metadata' => 'setShouldRedactAccessCodeMetadata',
        'upload_new_image_to_sign_or_initial' => 'setUploadNewImageToSignOrInitial',
        'upload_new_image_to_sign_or_initial_metadata' => 'setUploadNewImageToSignOrInitialMetadata'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'admin_message' => 'getAdminMessage',
        'allow_users_to_edit_shared_access' => 'getAllowUsersToEditSharedAccess',
        'allow_users_to_edit_shared_access_metadata' => 'getAllowUsersToEditSharedAccessMetadata',
        'ask_an_admin' => 'getAskAnAdmin',
        'clickwrap_schema_version' => 'getClickwrapSchemaVersion',
        'clickwrap_schema_version_metadata' => 'getClickwrapSchemaVersionMetadata',
        'enable_admin_message' => 'getEnableAdminMessage',
        'enable_admin_message_metadata' => 'getEnableAdminMessageMetadata',
        'enable_easy_sign_can_use_multi_template_apply' => 'getEnableEasySignCanUseMultiTemplateApply',
        'enable_easy_sign_can_use_multi_template_apply_metadata' => 'getEnableEasySignCanUseMultiTemplateApplyMetadata',
        'enable_easy_sign_template_upload' => 'getEnableEasySignTemplateUpload',
        'enable_easy_sign_template_upload_metadata' => 'getEnableEasySignTemplateUploadMetadata',
        'enable_envelope_copy_with_data' => 'getEnableEnvelopeCopyWithData',
        'enable_envelope_copy_with_data_metadata' => 'getEnableEnvelopeCopyWithDataMetadata',
        'enable_legacy_sendflow_link' => 'getEnableLegacySendflowLink',
        'enable_legacy_sendflow_link_metadata' => 'getEnableLegacySendflowLinkMetadata',
        'has_external_linked_accounts' => 'getHasExternalLinkedAccounts',
        'has_external_linked_accounts_metadata' => 'getHasExternalLinkedAccountsMetadata',
        'hide_send_an_envelope' => 'getHideSendAnEnvelope',
        'hide_send_an_envelope_metadata' => 'getHideSendAnEnvelopeMetadata',
        'hide_use_a_template' => 'getHideUseATemplate',
        'hide_use_a_template_in_prepare' => 'getHideUseATemplateInPrepare',
        'hide_use_a_template_in_prepare_metadata' => 'getHideUseATemplateInPrepareMetadata',
        'hide_use_a_template_metadata' => 'getHideUseATemplateMetadata',
        'order_based_recipient_id_generation' => 'getOrderBasedRecipientIdGeneration',
        'order_based_recipient_id_generation_metadata' => 'getOrderBasedRecipientIdGenerationMetadata',
        'remove_envelope_forwarding' => 'getRemoveEnvelopeForwarding',
        'remove_envelope_forwarding_metadata' => 'getRemoveEnvelopeForwardingMetadata',
        'should_redact_access_code' => 'getShouldRedactAccessCode',
        'should_redact_access_code_metadata' => 'getShouldRedactAccessCodeMetadata',
        'upload_new_image_to_sign_or_initial' => 'getUploadNewImageToSignOrInitial',
        'upload_new_image_to_sign_or_initial_metadata' => 'getUploadNewImageToSignOrInitialMetadata'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['admin_message'] = isset($data['admin_message']) ? $data['admin_message'] : null;
        $this->container['allow_users_to_edit_shared_access'] = isset($data['allow_users_to_edit_shared_access']) ? $data['allow_users_to_edit_shared_access'] : null;
        $this->container['allow_users_to_edit_shared_access_metadata'] = isset($data['allow_users_to_edit_shared_access_metadata']) ? $data['allow_users_to_edit_shared_access_metadata'] : null;
        $this->container['ask_an_admin'] = isset($data['ask_an_admin']) ? $data['ask_an_admin'] : null;
        $this->container['clickwrap_schema_version'] = isset($data['clickwrap_schema_version']) ? $data['clickwrap_schema_version'] : null;
        $this->container['clickwrap_schema_version_metadata'] = isset($data['clickwrap_schema_version_metadata']) ? $data['clickwrap_schema_version_metadata'] : null;
        $this->container['enable_admin_message'] = isset($data['enable_admin_message']) ? $data['enable_admin_message'] : null;
        $this->container['enable_admin_message_metadata'] = isset($data['enable_admin_message_metadata']) ? $data['enable_admin_message_metadata'] : null;
        $this->container['enable_easy_sign_can_use_multi_template_apply'] = isset($data['enable_easy_sign_can_use_multi_template_apply']) ? $data['enable_easy_sign_can_use_multi_template_apply'] : null;
        $this->container['enable_easy_sign_can_use_multi_template_apply_metadata'] = isset($data['enable_easy_sign_can_use_multi_template_apply_metadata']) ? $data['enable_easy_sign_can_use_multi_template_apply_metadata'] : null;
        $this->container['enable_easy_sign_template_upload'] = isset($data['enable_easy_sign_template_upload']) ? $data['enable_easy_sign_template_upload'] : null;
        $this->container['enable_easy_sign_template_upload_metadata'] = isset($data['enable_easy_sign_template_upload_metadata']) ? $data['enable_easy_sign_template_upload_metadata'] : null;
        $this->container['enable_envelope_copy_with_data'] = isset($data['enable_envelope_copy_with_data']) ? $data['enable_envelope_copy_with_data'] : null;
        $this->container['enable_envelope_copy_with_data_metadata'] = isset($data['enable_envelope_copy_with_data_metadata']) ? $data['enable_envelope_copy_with_data_metadata'] : null;
        $this->container['enable_legacy_sendflow_link'] = isset($data['enable_legacy_sendflow_link']) ? $data['enable_legacy_sendflow_link'] : null;
        $this->container['enable_legacy_sendflow_link_metadata'] = isset($data['enable_legacy_sendflow_link_metadata']) ? $data['enable_legacy_sendflow_link_metadata'] : null;
        $this->container['has_external_linked_accounts'] = isset($data['has_external_linked_accounts']) ? $data['has_external_linked_accounts'] : null;
        $this->container['has_external_linked_accounts_metadata'] = isset($data['has_external_linked_accounts_metadata']) ? $data['has_external_linked_accounts_metadata'] : null;
        $this->container['hide_send_an_envelope'] = isset($data['hide_send_an_envelope']) ? $data['hide_send_an_envelope'] : null;
        $this->container['hide_send_an_envelope_metadata'] = isset($data['hide_send_an_envelope_metadata']) ? $data['hide_send_an_envelope_metadata'] : null;
        $this->container['hide_use_a_template'] = isset($data['hide_use_a_template']) ? $data['hide_use_a_template'] : null;
        $this->container['hide_use_a_template_in_prepare'] = isset($data['hide_use_a_template_in_prepare']) ? $data['hide_use_a_template_in_prepare'] : null;
        $this->container['hide_use_a_template_in_prepare_metadata'] = isset($data['hide_use_a_template_in_prepare_metadata']) ? $data['hide_use_a_template_in_prepare_metadata'] : null;
        $this->container['hide_use_a_template_metadata'] = isset($data['hide_use_a_template_metadata']) ? $data['hide_use_a_template_metadata'] : null;
        $this->container['order_based_recipient_id_generation'] = isset($data['order_based_recipient_id_generation']) ? $data['order_based_recipient_id_generation'] : null;
        $this->container['order_based_recipient_id_generation_metadata'] = isset($data['order_based_recipient_id_generation_metadata']) ? $data['order_based_recipient_id_generation_metadata'] : null;
        $this->container['remove_envelope_forwarding'] = isset($data['remove_envelope_forwarding']) ? $data['remove_envelope_forwarding'] : null;
        $this->container['remove_envelope_forwarding_metadata'] = isset($data['remove_envelope_forwarding_metadata']) ? $data['remove_envelope_forwarding_metadata'] : null;
        $this->container['should_redact_access_code'] = isset($data['should_redact_access_code']) ? $data['should_redact_access_code'] : null;
        $this->container['should_redact_access_code_metadata'] = isset($data['should_redact_access_code_metadata']) ? $data['should_redact_access_code_metadata'] : null;
        $this->container['upload_new_image_to_sign_or_initial'] = isset($data['upload_new_image_to_sign_or_initial']) ? $data['upload_new_image_to_sign_or_initial'] : null;
        $this->container['upload_new_image_to_sign_or_initial_metadata'] = isset($data['upload_new_image_to_sign_or_initial_metadata']) ? $data['upload_new_image_to_sign_or_initial_metadata'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets admin_message
     *
     * @return \DocuSign\eSign\Model\AdminMessage
     */
    public function getAdminMessage()
    {
        return $this->container['admin_message'];
    }

    /**
     * Sets admin_message
     *
     * @param \DocuSign\eSign\Model\AdminMessage $admin_message 
     *
     * @return $this
     */
    public function setAdminMessage($admin_message)
    {
        $this->container['admin_message'] = $admin_message;

        return $this;
    }

    /**
     * Gets allow_users_to_edit_shared_access
     *
     * @return ?string
     */
    public function getAllowUsersToEditSharedAccess()
    {
        return $this->container['allow_users_to_edit_shared_access'];
    }

    /**
     * Sets allow_users_to_edit_shared_access
     *
     * @param ?string $allow_users_to_edit_shared_access 
     *
     * @return $this
     */
    public function setAllowUsersToEditSharedAccess($allow_users_to_edit_shared_access)
    {
        $this->container['allow_users_to_edit_shared_access'] = $allow_users_to_edit_shared_access;

        return $this;
    }

    /**
     * Gets allow_users_to_edit_shared_access_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowUsersToEditSharedAccessMetadata()
    {
        return $this->container['allow_users_to_edit_shared_access_metadata'];
    }

    /**
     * Sets allow_users_to_edit_shared_access_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_users_to_edit_shared_access_metadata 
     *
     * @return $this
     */
    public function setAllowUsersToEditSharedAccessMetadata($allow_users_to_edit_shared_access_metadata)
    {
        $this->container['allow_users_to_edit_shared_access_metadata'] = $allow_users_to_edit_shared_access_metadata;

        return $this;
    }

    /**
     * Gets ask_an_admin
     *
     * @return \DocuSign\eSign\Model\AskAnAdmin
     */
    public function getAskAnAdmin()
    {
        return $this->container['ask_an_admin'];
    }

    /**
     * Sets ask_an_admin
     *
     * @param \DocuSign\eSign\Model\AskAnAdmin $ask_an_admin 
     *
     * @return $this
     */
    public function setAskAnAdmin($ask_an_admin)
    {
        $this->container['ask_an_admin'] = $ask_an_admin;

        return $this;
    }

    /**
     * Gets clickwrap_schema_version
     *
     * @return ?string
     */
    public function getClickwrapSchemaVersion()
    {
        return $this->container['clickwrap_schema_version'];
    }

    /**
     * Sets clickwrap_schema_version
     *
     * @param ?string $clickwrap_schema_version 
     *
     * @return $this
     */
    public function setClickwrapSchemaVersion($clickwrap_schema_version)
    {
        $this->container['clickwrap_schema_version'] = $clickwrap_schema_version;

        return $this;
    }

    /**
     * Gets clickwrap_schema_version_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getClickwrapSchemaVersionMetadata()
    {
        return $this->container['clickwrap_schema_version_metadata'];
    }

    /**
     * Sets clickwrap_schema_version_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $clickwrap_schema_version_metadata 
     *
     * @return $this
     */
    public function setClickwrapSchemaVersionMetadata($clickwrap_schema_version_metadata)
    {
        $this->container['clickwrap_schema_version_metadata'] = $clickwrap_schema_version_metadata;

        return $this;
    }

    /**
     * Gets enable_admin_message
     *
     * @return ?string
     */
    public function getEnableAdminMessage()
    {
        return $this->container['enable_admin_message'];
    }

    /**
     * Sets enable_admin_message
     *
     * @param ?string $enable_admin_message 
     *
     * @return $this
     */
    public function setEnableAdminMessage($enable_admin_message)
    {
        $this->container['enable_admin_message'] = $enable_admin_message;

        return $this;
    }

    /**
     * Gets enable_admin_message_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableAdminMessageMetadata()
    {
        return $this->container['enable_admin_message_metadata'];
    }

    /**
     * Sets enable_admin_message_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_admin_message_metadata 
     *
     * @return $this
     */
    public function setEnableAdminMessageMetadata($enable_admin_message_metadata)
    {
        $this->container['enable_admin_message_metadata'] = $enable_admin_message_metadata;

        return $this;
    }

    /**
     * Gets enable_easy_sign_can_use_multi_template_apply
     *
     * @return ?string
     */
    public function getEnableEasySignCanUseMultiTemplateApply()
    {
        return $this->container['enable_easy_sign_can_use_multi_template_apply'];
    }

    /**
     * Sets enable_easy_sign_can_use_multi_template_apply
     *
     * @param ?string $enable_easy_sign_can_use_multi_template_apply 
     *
     * @return $this
     */
    public function setEnableEasySignCanUseMultiTemplateApply($enable_easy_sign_can_use_multi_template_apply)
    {
        $this->container['enable_easy_sign_can_use_multi_template_apply'] = $enable_easy_sign_can_use_multi_template_apply;

        return $this;
    }

    /**
     * Gets enable_easy_sign_can_use_multi_template_apply_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableEasySignCanUseMultiTemplateApplyMetadata()
    {
        return $this->container['enable_easy_sign_can_use_multi_template_apply_metadata'];
    }

    /**
     * Sets enable_easy_sign_can_use_multi_template_apply_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_easy_sign_can_use_multi_template_apply_metadata 
     *
     * @return $this
     */
    public function setEnableEasySignCanUseMultiTemplateApplyMetadata($enable_easy_sign_can_use_multi_template_apply_metadata)
    {
        $this->container['enable_easy_sign_can_use_multi_template_apply_metadata'] = $enable_easy_sign_can_use_multi_template_apply_metadata;

        return $this;
    }

    /**
     * Gets enable_easy_sign_template_upload
     *
     * @return ?string
     */
    public function getEnableEasySignTemplateUpload()
    {
        return $this->container['enable_easy_sign_template_upload'];
    }

    /**
     * Sets enable_easy_sign_template_upload
     *
     * @param ?string $enable_easy_sign_template_upload 
     *
     * @return $this
     */
    public function setEnableEasySignTemplateUpload($enable_easy_sign_template_upload)
    {
        $this->container['enable_easy_sign_template_upload'] = $enable_easy_sign_template_upload;

        return $this;
    }

    /**
     * Gets enable_easy_sign_template_upload_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableEasySignTemplateUploadMetadata()
    {
        return $this->container['enable_easy_sign_template_upload_metadata'];
    }

    /**
     * Sets enable_easy_sign_template_upload_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_easy_sign_template_upload_metadata 
     *
     * @return $this
     */
    public function setEnableEasySignTemplateUploadMetadata($enable_easy_sign_template_upload_metadata)
    {
        $this->container['enable_easy_sign_template_upload_metadata'] = $enable_easy_sign_template_upload_metadata;

        return $this;
    }

    /**
     * Gets enable_envelope_copy_with_data
     *
     * @return ?string
     */
    public function getEnableEnvelopeCopyWithData()
    {
        return $this->container['enable_envelope_copy_with_data'];
    }

    /**
     * Sets enable_envelope_copy_with_data
     *
     * @param ?string $enable_envelope_copy_with_data 
     *
     * @return $this
     */
    public function setEnableEnvelopeCopyWithData($enable_envelope_copy_with_data)
    {
        $this->container['enable_envelope_copy_with_data'] = $enable_envelope_copy_with_data;

        return $this;
    }

    /**
     * Gets enable_envelope_copy_with_data_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableEnvelopeCopyWithDataMetadata()
    {
        return $this->container['enable_envelope_copy_with_data_metadata'];
    }

    /**
     * Sets enable_envelope_copy_with_data_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_envelope_copy_with_data_metadata 
     *
     * @return $this
     */
    public function setEnableEnvelopeCopyWithDataMetadata($enable_envelope_copy_with_data_metadata)
    {
        $this->container['enable_envelope_copy_with_data_metadata'] = $enable_envelope_copy_with_data_metadata;

        return $this;
    }

    /**
     * Gets enable_legacy_sendflow_link
     *
     * @return ?string
     */
    public function getEnableLegacySendflowLink()
    {
        return $this->container['enable_legacy_sendflow_link'];
    }

    /**
     * Sets enable_legacy_sendflow_link
     *
     * @param ?string $enable_legacy_sendflow_link 
     *
     * @return $this
     */
    public function setEnableLegacySendflowLink($enable_legacy_sendflow_link)
    {
        $this->container['enable_legacy_sendflow_link'] = $enable_legacy_sendflow_link;

        return $this;
    }

    /**
     * Gets enable_legacy_sendflow_link_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableLegacySendflowLinkMetadata()
    {
        return $this->container['enable_legacy_sendflow_link_metadata'];
    }

    /**
     * Sets enable_legacy_sendflow_link_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_legacy_sendflow_link_metadata 
     *
     * @return $this
     */
    public function setEnableLegacySendflowLinkMetadata($enable_legacy_sendflow_link_metadata)
    {
        $this->container['enable_legacy_sendflow_link_metadata'] = $enable_legacy_sendflow_link_metadata;

        return $this;
    }

    /**
     * Gets has_external_linked_accounts
     *
     * @return ?string
     */
    public function getHasExternalLinkedAccounts()
    {
        return $this->container['has_external_linked_accounts'];
    }

    /**
     * Sets has_external_linked_accounts
     *
     * @param ?string $has_external_linked_accounts 
     *
     * @return $this
     */
    public function setHasExternalLinkedAccounts($has_external_linked_accounts)
    {
        $this->container['has_external_linked_accounts'] = $has_external_linked_accounts;

        return $this;
    }

    /**
     * Gets has_external_linked_accounts_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getHasExternalLinkedAccountsMetadata()
    {
        return $this->container['has_external_linked_accounts_metadata'];
    }

    /**
     * Sets has_external_linked_accounts_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $has_external_linked_accounts_metadata 
     *
     * @return $this
     */
    public function setHasExternalLinkedAccountsMetadata($has_external_linked_accounts_metadata)
    {
        $this->container['has_external_linked_accounts_metadata'] = $has_external_linked_accounts_metadata;

        return $this;
    }

    /**
     * Gets hide_send_an_envelope
     *
     * @return ?string
     */
    public function getHideSendAnEnvelope()
    {
        return $this->container['hide_send_an_envelope'];
    }

    /**
     * Sets hide_send_an_envelope
     *
     * @param ?string $hide_send_an_envelope 
     *
     * @return $this
     */
    public function setHideSendAnEnvelope($hide_send_an_envelope)
    {
        $this->container['hide_send_an_envelope'] = $hide_send_an_envelope;

        return $this;
    }

    /**
     * Gets hide_send_an_envelope_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getHideSendAnEnvelopeMetadata()
    {
        return $this->container['hide_send_an_envelope_metadata'];
    }

    /**
     * Sets hide_send_an_envelope_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $hide_send_an_envelope_metadata 
     *
     * @return $this
     */
    public function setHideSendAnEnvelopeMetadata($hide_send_an_envelope_metadata)
    {
        $this->container['hide_send_an_envelope_metadata'] = $hide_send_an_envelope_metadata;

        return $this;
    }

    /**
     * Gets hide_use_a_template
     *
     * @return ?string
     */
    public function getHideUseATemplate()
    {
        return $this->container['hide_use_a_template'];
    }

    /**
     * Sets hide_use_a_template
     *
     * @param ?string $hide_use_a_template 
     *
     * @return $this
     */
    public function setHideUseATemplate($hide_use_a_template)
    {
        $this->container['hide_use_a_template'] = $hide_use_a_template;

        return $this;
    }

    /**
     * Gets hide_use_a_template_in_prepare
     *
     * @return ?string
     */
    public function getHideUseATemplateInPrepare()
    {
        return $this->container['hide_use_a_template_in_prepare'];
    }

    /**
     * Sets hide_use_a_template_in_prepare
     *
     * @param ?string $hide_use_a_template_in_prepare 
     *
     * @return $this
     */
    public function setHideUseATemplateInPrepare($hide_use_a_template_in_prepare)
    {
        $this->container['hide_use_a_template_in_prepare'] = $hide_use_a_template_in_prepare;

        return $this;
    }

    /**
     * Gets hide_use_a_template_in_prepare_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getHideUseATemplateInPrepareMetadata()
    {
        return $this->container['hide_use_a_template_in_prepare_metadata'];
    }

    /**
     * Sets hide_use_a_template_in_prepare_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $hide_use_a_template_in_prepare_metadata 
     *
     * @return $this
     */
    public function setHideUseATemplateInPrepareMetadata($hide_use_a_template_in_prepare_metadata)
    {
        $this->container['hide_use_a_template_in_prepare_metadata'] = $hide_use_a_template_in_prepare_metadata;

        return $this;
    }

    /**
     * Gets hide_use_a_template_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getHideUseATemplateMetadata()
    {
        return $this->container['hide_use_a_template_metadata'];
    }

    /**
     * Sets hide_use_a_template_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $hide_use_a_template_metadata 
     *
     * @return $this
     */
    public function setHideUseATemplateMetadata($hide_use_a_template_metadata)
    {
        $this->container['hide_use_a_template_metadata'] = $hide_use_a_template_metadata;

        return $this;
    }

    /**
     * Gets order_based_recipient_id_generation
     *
     * @return ?string
     */
    public function getOrderBasedRecipientIdGeneration()
    {
        return $this->container['order_based_recipient_id_generation'];
    }

    /**
     * Sets order_based_recipient_id_generation
     *
     * @param ?string $order_based_recipient_id_generation 
     *
     * @return $this
     */
    public function setOrderBasedRecipientIdGeneration($order_based_recipient_id_generation)
    {
        $this->container['order_based_recipient_id_generation'] = $order_based_recipient_id_generation;

        return $this;
    }

    /**
     * Gets order_based_recipient_id_generation_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getOrderBasedRecipientIdGenerationMetadata()
    {
        return $this->container['order_based_recipient_id_generation_metadata'];
    }

    /**
     * Sets order_based_recipient_id_generation_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $order_based_recipient_id_generation_metadata 
     *
     * @return $this
     */
    public function setOrderBasedRecipientIdGenerationMetadata($order_based_recipient_id_generation_metadata)
    {
        $this->container['order_based_recipient_id_generation_metadata'] = $order_based_recipient_id_generation_metadata;

        return $this;
    }

    /**
     * Gets remove_envelope_forwarding
     *
     * @return ?string
     */
    public function getRemoveEnvelopeForwarding()
    {
        return $this->container['remove_envelope_forwarding'];
    }

    /**
     * Sets remove_envelope_forwarding
     *
     * @param ?string $remove_envelope_forwarding 
     *
     * @return $this
     */
    public function setRemoveEnvelopeForwarding($remove_envelope_forwarding)
    {
        $this->container['remove_envelope_forwarding'] = $remove_envelope_forwarding;

        return $this;
    }

    /**
     * Gets remove_envelope_forwarding_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getRemoveEnvelopeForwardingMetadata()
    {
        return $this->container['remove_envelope_forwarding_metadata'];
    }

    /**
     * Sets remove_envelope_forwarding_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $remove_envelope_forwarding_metadata 
     *
     * @return $this
     */
    public function setRemoveEnvelopeForwardingMetadata($remove_envelope_forwarding_metadata)
    {
        $this->container['remove_envelope_forwarding_metadata'] = $remove_envelope_forwarding_metadata;

        return $this;
    }

    /**
     * Gets should_redact_access_code
     *
     * @return ?string
     */
    public function getShouldRedactAccessCode()
    {
        return $this->container['should_redact_access_code'];
    }

    /**
     * Sets should_redact_access_code
     *
     * @param ?string $should_redact_access_code 
     *
     * @return $this
     */
    public function setShouldRedactAccessCode($should_redact_access_code)
    {
        $this->container['should_redact_access_code'] = $should_redact_access_code;

        return $this;
    }

    /**
     * Gets should_redact_access_code_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getShouldRedactAccessCodeMetadata()
    {
        return $this->container['should_redact_access_code_metadata'];
    }

    /**
     * Sets should_redact_access_code_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $should_redact_access_code_metadata 
     *
     * @return $this
     */
    public function setShouldRedactAccessCodeMetadata($should_redact_access_code_metadata)
    {
        $this->container['should_redact_access_code_metadata'] = $should_redact_access_code_metadata;

        return $this;
    }

    /**
     * Gets upload_new_image_to_sign_or_initial
     *
     * @return ?string
     */
    public function getUploadNewImageToSignOrInitial()
    {
        return $this->container['upload_new_image_to_sign_or_initial'];
    }

    /**
     * Sets upload_new_image_to_sign_or_initial
     *
     * @param ?string $upload_new_image_to_sign_or_initial 
     *
     * @return $this
     */
    public function setUploadNewImageToSignOrInitial($upload_new_image_to_sign_or_initial)
    {
        $this->container['upload_new_image_to_sign_or_initial'] = $upload_new_image_to_sign_or_initial;

        return $this;
    }

    /**
     * Gets upload_new_image_to_sign_or_initial_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getUploadNewImageToSignOrInitialMetadata()
    {
        return $this->container['upload_new_image_to_sign_or_initial_metadata'];
    }

    /**
     * Sets upload_new_image_to_sign_or_initial_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $upload_new_image_to_sign_or_initial_metadata 
     *
     * @return $this
     */
    public function setUploadNewImageToSignOrInitialMetadata($upload_new_image_to_sign_or_initial_metadata)
    {
        $this->container['upload_new_image_to_sign_or_initial_metadata'] = $upload_new_image_to_sign_or_initial_metadata;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}

